/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.bridge.request;

import com.ibm.hwmca.fw.bridge.NativeBridge;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;

class Signature {
    NativeBridge bridge;
    Class[] parms;

    public Signature(String signature, NativeBridge bridge) throws IOException {
        this.bridge = bridge;
        this.parseSignature(signature);
    }

    public Object[] readArguments(DataInputStream in) throws IOException {
        Object[] args = new Object[this.parms.length];
        for (int i = 0; i < args.length; ++i) {
            Class parm = this.parms[i];
            if (parm.isPrimitive()) {
                if (parm == Boolean.TYPE) {
                    args[i] = in.readBoolean();
                    continue;
                }
                if (parm == Byte.TYPE) {
                    args[i] = new Byte(in.readByte());
                    continue;
                }
                if (parm == Character.TYPE) {
                    args[i] = new Character(in.readChar());
                    continue;
                }
                if (parm == Short.TYPE) {
                    args[i] = new Short(in.readShort());
                    continue;
                }
                if (parm == Integer.TYPE) {
                    args[i] = new Integer(in.readInt());
                    continue;
                }
                if (parm == Long.TYPE) {
                    args[i] = new Long(in.readLong());
                    continue;
                }
                if (parm == Float.TYPE) {
                    args[i] = new Float(in.readFloat());
                    continue;
                }
                if (parm == Double.TYPE) {
                    args[i] = new Double(in.readDouble());
                    continue;
                }
                throw new IOException("Unknown primitive type");
            }
            String name = in.readUTF();
            args[i] = this.bridge.lookupRegisteredObject(name);
            if (args[i] != null || name.equals("null")) continue;
            throw new IOException("Unknown object name \"" + name + "\" passed as argument " + i);
        }
        return args;
    }

    public Class[] getParameterClasses() {
        return this.parms;
    }

    void parseSignature(String signature) throws IOException {
        ArrayList parms = new ArrayList();
        int len = signature.length();
        StringBuffer parmClassName = new StringBuffer();
        block16: for (int index = 0; index < len; ++index) {
            block19: {
                block18: {
                    char c = signature.charAt(index);
                    switch (c) {
                        case '[': {
                            parmClassName.append(c);
                            continue block16;
                        }
                        case 'L': {
                            int end = signature.indexOf(59, index + 1);
                            if (end == -1) {
                                throw new IOException("Illegal signature string \"" + signature + "\", starting at index " + index);
                            }
                            parmClassName.append(signature.substring(index, end + 1));
                            index = end;
                            break;
                        }
                        default: {
                            parmClassName.append(c);
                        }
                    }
                    if (parmClassName.length() != 1) break block18;
                    switch (parmClassName.charAt(0)) {
                        case 'Z': {
                            parms.add(Boolean.TYPE);
                            break block19;
                        }
                        case 'B': {
                            parms.add(Byte.TYPE);
                            break block19;
                        }
                        case 'C': {
                            parms.add(Character.TYPE);
                            break block19;
                        }
                        case 'S': {
                            parms.add(Short.TYPE);
                            break block19;
                        }
                        case 'I': {
                            parms.add(Integer.TYPE);
                            break block19;
                        }
                        case 'J': {
                            parms.add(Long.TYPE);
                            break block19;
                        }
                        case 'F': {
                            parms.add(Float.TYPE);
                            break block19;
                        }
                        case 'D': {
                            parms.add(Double.TYPE);
                            break block19;
                        }
                        default: {
                            throw new IOException("Illegal type char \"" + parmClassName.charAt(0) + "\" in signature string \"" + signature + "\", at index " + index);
                        }
                    }
                }
                String className = parmClassName.charAt(0) == '[' ? parmClassName.toString() : parmClassName.substring(1, parmClassName.length() - 1);
                className = className.replace('/', '.');
                try {
                    this.getClass();
                    parms.add(Class.forName(className));
                }
                catch (ClassNotFoundException e) {
                    throw new IOException("Class name not found: \"" + className + "\"");
                }
            }
            parmClassName.setLength(0);
        }
        this.parms = new Class[parms.size()];
        parms.toArray(this.parms);
    }
}

